<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('city', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('airports', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('city')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('airline_packages', function(Blueprint $table) {
			$table->foreign('airline_id')->references('id')->on('airline')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('airline_packages', function(Blueprint $table) {
			$table->foreign('airline_classes_id')->references('id')->on('airline_classes')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('airline_packages_id')->references('id')->on('airline_packages')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('city', function(Blueprint $table) {
			$table->dropForeign('city_country_id_foreign');
		});
		Schema::table('airports', function(Blueprint $table) {
			$table->dropForeign('airports_city_id_foreign');
		});
		Schema::table('airline_packages', function(Blueprint $table) {
			$table->dropForeign('airline_packages_airline_id_foreign');
		});
		Schema::table('airline_packages', function(Blueprint $table) {
			$table->dropForeign('airline_packages_airline_classes_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_customer_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_customer_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_airline_packages_id_foreign');
		});
	}
}