<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('skills', function(Blueprint $table) {
			$table->foreign('users_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Scores', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('advices', function(Blueprint $table) {
			$table->foreign('skill_id')->references('id')->on('skills')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('households', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_containers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_containers', function(Blueprint $table) {
			$table->foreign('trash_id')->references('id')->on('containers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_skills', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_skills', function(Blueprint $table) {
			$table->foreign('skill_id')->references('id')->on('skills')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Waste_containers', function(Blueprint $table) {
			$table->foreign('waste_id')->references('id')->on('waste_list')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('skills', function(Blueprint $table) {
			$table->dropForeign('skills_users_id_foreign');
		});
		Schema::table('Scores', function(Blueprint $table) {
			$table->dropForeign('Scores_user_id_foreign');
		});
		Schema::table('advices', function(Blueprint $table) {
			$table->dropForeign('advices_skill_id_foreign');
		});
		Schema::table('households', function(Blueprint $table) {
			$table->dropForeign('households_user_id_foreign');
		});
		Schema::table('user_containers', function(Blueprint $table) {
			$table->dropForeign('user_containers_user_id_foreign');
		});
		Schema::table('user_containers', function(Blueprint $table) {
			$table->dropForeign('user_containers_trash_id_foreign');
		});
		Schema::table('user_skills', function(Blueprint $table) {
			$table->dropForeign('user_skills_user_id_foreign');
		});
		Schema::table('user_skills', function(Blueprint $table) {
			$table->dropForeign('user_skills_skill_id_foreign');
		});
		Schema::table('Waste_containers', function(Blueprint $table) {
			$table->dropForeign('Waste_containers_waste_id_foreign');
		});
	}
}