<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCandidatesTable extends Migration {

	public function up()
	{
		Schema::create('candidates', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('first_name', 191);
			$table->string('last_name', 191);
			$table->text('avatar')->nullable();
			$table->string('phone', 20)->nullable();
			$table->text('description')->nullable();
			$table->text('cover_letter');
			$table->date('dob');
			$table->integer('region_id');
			$table->tinyInteger('status');
			$table->tinyInteger('is_educated');
			$table->tinyInteger('is_experienced');
			$table->integer('profile_level');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('candidates');
	}
}