<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobsTable extends Migration {

	public function up()
	{
		Schema::create('jobs', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('company_id');
			$table->integer('candidate_id');
			$table->integer('user_id');
			$table->string('company_name', 191)->nullable();
			$table->text('company_logo')->nullable();
			$table->string('title', 191);
			$table->text('description');
			$table->text('image')->nullable();
			$table->integer('industry_id');
			$table->integer('job_type_id');
			$table->integer('job_mode_id');
			$table->integer('edu_level_id');
			$table->text('address');
			$table->integer('region_id');
			$table->date('application_deadline');
			$table->tinyInteger('status');
			$table->date('published_date')->nullable();
			$table->date('start_date');
			$table->date('end_date');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('jobs');
	}
}