<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title');
			$table->integer('store_id')->unsigned();
			$table->string('short_description');
			$table->string('brand_name');
			$table->string('percentage_discount');
			$table->string('description');
			$table->text('shipping_information')->nullable();
			$table->text('return_policy')->nullable();
			$table->text('specification')->nullable();
			$table->text('warranty')->nullable();
			$table->string('price');
			$table->integer('product_type_id')->unsigned();
			$table->string('feature_image');
			$table->boolean('terms_and_conditions');
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}