<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->string('street');
			$table->string('area');
			$table->string('city');
			$table->integer('country_id')->unsigned();
			$table->integer('state_id')->unsigned();
			$table->integer('local_government_id')->unsigned();
			$table->boolean('store_pickup');
			$table->string('delivery_options');
			$table->string('voucher_code');
			$table->string('voucher_discount');
			$table->string('delivery_charge');
			$table->string('total_amount');
			$table->string('final_amount');
			$table->string('payment_gateway');
			$table->string('card_holder_name');
			$table->string('status');
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}