<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user_b2b_regla_ventas', function(Blueprint $table) {
			$table->foreign('userb2b_id')->references('id')->on('user_b2bs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_b2b_regla_ventas', function(Blueprint $table) {
			$table->foreign('regla_producto_venta_id')->references('id')->on('regla_producto_ventas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('user_b2b_regla_ventas', function(Blueprint $table) {
			$table->dropForeign('user_b2b_regla_ventas_userb2b_id_foreign');
		});
		Schema::table('user_b2b_regla_ventas', function(Blueprint $table) {
			$table->dropForeign('user_b2b_regla_ventas_regla_producto_venta_id_foreign');
		});
	}
}