<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDepotsTable extends Migration {

	public function up()
	{
		Schema::create('depots', function(Blueprint $table) {
			$table->string('slug', 255);
			$table->integer('id_client')->unsigned();
			$table->increments('id');
			$table->integer('id_createur')->unsigned();
			$table->integer('id_compte')->unsigned();
			$table->integer('id_plan')->unsigned();
			$table->integer('id_agence')->unsigned()->nullable();
			$table->string('type', 255)->default('Dépôt');
			$table->integer('montant');
			$table->integer('montantAppliqInteret')->nullable();
			$table->timestamps();
			$table->softDeletes();
			$table->boolean('etat')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('depots');
	}
}