<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Depot extends Eloquent {

	protected $table = 'depots';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'id_client', 'id_createur', 'id_compte', 'id_plan', 'id_agence', 'type', 'montant', 'montantAppliqInteret', 'etat');
	protected $visible = array('slug', 'id_client', 'id_createur', 'id_compte', 'id_plan', 'id_agence', 'type', 'montant', 'montantAppliqInteret', 'etat');

	public function client()
	{
		return $this->belongsTo('App\Client', 'id_client');
	}

	public function createur()
	{
		return $this->belongsTo('App\Utilisateur', 'id_createur');
	}

	public function compte()
	{
		return $this->belongsTo('App\Compte', 'id_compte');
	}

	public function plan()
	{
		return $this->belongsTo('App\Plan', 'id_plan');
	}

	public function agence()
	{
		return $this->belongsTo('App\Agence', 'id_agence');
	}

}