<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Compte extends Model 
{

    protected $table = 'comptes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slug', 'id_client', 'telephone', 'etat');
    protected $visible = array('slug', 'id_client', 'telephone', 'etat');

    public function client()
    {
        return $this->belongsTo('App\Client', 'id_client');
    }

    public function depot()
    {
        return $this->hasMany('App\Depot', 'id_depot');
    }

}