<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Fichier extends Model 
{

    protected $table = 'fichiers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('id_createur', 'slug', 'libelle');
    protected $visible = array('id_createur', 'slug', 'libelle');

    public function createur()
    {
        return $this->belongsTo('App\Utilisateur', 'id_createur');
    }

}