<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Interet extends Model 
{

    protected $table = 'interets';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slug', 'id_client', 'montant');
    protected $visible = array('slug', 'id_client', 'montant');

    public function client()
    {
        return $this->belongsTo('App\Client', 'id_client');
    }

}