<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Utilisateur extends Model 
{

    protected $table = 'utilisateurs';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slug', 'nom', 'poste', 'photo', 'mot_pass', 'telephone', 'prenom', 'etat');
    protected $visible = array('slug', 'nom', 'poste', 'photo', 'mot_pass', 'telephone', 'prenom', 'etat');

    public function retrait()
    {
        return $this->hasMany('App\Retrait', 'id_createur');
    }

    public function client()
    {
        return $this->hasMany('App\Client', 'id_createur');
    }

    public function depot()
    {
        return $this->hasMany('App\Depot', 'id_createur');
    }

    public function clientStorry()
    {
        return $this->hasMany('App\ClientSorry', 'id_createur');
    }

    public function fichier()
    {
        return $this->hasMany('App\Fichier', 'id_createur');
    }

}