<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('socials', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('socials')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_details', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('user_details')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('throttles', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('throttles')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('socials', function(Blueprint $table) {
			$table->dropForeign('socials_user_id_foreign');
		});
		Schema::table('user_details', function(Blueprint $table) {
			$table->dropForeign('user_details_user_id_foreign');
		});
		Schema::table('throttles', function(Blueprint $table) {
			$table->dropForeign('throttles_user_id_foreign');
		});
	}
}