<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function socials()
	{
		return $this->hasMany('Social');
	}

	public function details()
	{
		return $this->hasOne('UserDetail');
	}

	public function throttles()
	{
		return $this->hasMany('Throttle');
	}

	public function groups()
	{
		return $this->belongsToMany('Group', 'users_groups');
	}

}