<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVehiclesTable extends Migration {

	public function up()
	{
		Schema::create('vehicles', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('company_id')->unsigned()->nullable();
			$table->bigInteger('driver_id')->unsigned()->nullable();
			$table->string('name')->nullable();
			$table->string('auto_code')->nullable();
			$table->string('barcode')->nullable();
			$table->enum('fuel_type', array('91', '95', 'diesel'))->nullable();
			$table->string('dashboard')->nullable();
			$table->text('notes')->nullable();
			$table->enum('active', array('1', '0'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('vehicles');
	}
}