<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->enum('type', array('admin', 'company', 'station', 'driver'))->nullable();
			$table->string('username')->nullable();
			$table->string('password')->nullable();
			$table->string('fullname')->nullable();
			$table->string('email')->unique()->nullable();
			$table->enum('active', array('1', '0'))->nullable();
			$table->bigInteger('company_id')->unsigned()->nullable();
			$table->string('first_name')->nullable();
			$table->string('second_name')->nullable();
			$table->string('third_name')->nullable();
			$table->string('last_name')->nullable();
			$table->string('id_number')->nullable();
			$table->string('mobile')->nullable();
			$table->string('driver_licence')->nullable();
			$table->date('licence_expire_date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}