<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('code')->index();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('cart_id')->unsigned();
			$table->bigInteger('user_address_id')->unsigned();
			$table->integer('payment_type_id')->unsigned();
			$table->decimal('total', 10,3);
			$table->tinyInteger('status')->default('0');
			$table->decimal('discount', 10,3);
			$table->text('discount_code');
			$table->integer('earn_reward_point');
			$table->integer('use_reward_point');
			$table->softDeletes();
			$table->timestamps();
			$table->string('created_by')->nullable();
			$table->string('updated_by')->nullable();
			$table->string('deleted_by')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}