<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateImagesTable extends Migration {

	public function up()
	{
		Schema::create('images', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code')->index();
			$table->integer('product_id')->unsigned();
			$table->integer('attachment_id')->unsigned();
			$table->integer('parrent')->unsigned();
			$table->string('title');
			$table->text('description');
			$table->integer('width')->unsigned();
			$table->integer('height')->unsigned();
			$table->tinyInteger('status')->default('0');
			$table->softDeletes();
			$table->timestamps();
			$table->string('created_by')->nullable();
			$table->string('updated_by')->nullable();
			$table->string('deleted_by')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('images');
	}
}