<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('username', 30)->unique();
			$table->string('email', 100);
			$table->string('password', 100);
			$table->string('register_ip', 15);
			$table->string('forget_token', 100)->nullable();
			$table->string('active_token', 100)->nullable();
			$table->timestamps();
			$table->string('mobile');
			$table->boolean('is_active')->default(false);
			$table->boolean('is_deleted')->default(false);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}