<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserPaymentTable extends Migration {

	public function up()
	{
		Schema::create('user_payment', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code')->index();
			$table->bigInteger('user_id')->unsigned();
			$table->integer('payment_type_id')->unsigned();
			$table->integer('payment_id');
			$table->string('payment_number');
			$table->tinyInteger('status')->default('0');
			$table->softDeletes();
			$table->timestamps();
			$table->string('created_by')->nullable();
			$table->string('updated_by')->nullable();
			$table->string('deleted_by')->nullable();
			$table->tinyInteger('is_default');
		});
	}

	public function down()
	{
		Schema::drop('user_payment');
	}
}