<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('stocks', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('suppliers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branchs')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('standard_id')->references('id')->on('standards')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('source_id')->references('id')->on('sources')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('units')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('product_attribute', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('product_attribute', function(Blueprint $table) {
			$table->foreign('attribute_id')->references('id')->on('attributes')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('cart_items', function(Blueprint $table) {
			$table->foreign('cart_id')->references('id')->on('orders')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('cart_items', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('cart_id')->references('id')->on('cart')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_address_id')->references('id')->on('user_adress')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('payment_type_id')->references('id')->on('payment_type')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('images', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('images', function(Blueprint $table) {
			$table->foreign('attachment_id')->references('id')->on('attachments')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('login_attempts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rewiews', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('rewiews', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_adress', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_reward_point', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_reward_point', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_detail', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_detail', function(Blueprint $table) {
			$table->foreign('title_id')->references('id')->on('titles')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_payment', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_payment', function(Blueprint $table) {
			$table->foreign('payment_type_id')->references('id')->on('payment_type')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_payment', function(Blueprint $table) {
			$table->foreign('payment_id')->references('id')->on('payments')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('stocks', function(Blueprint $table) {
			$table->dropForeign('stocks_product_id_foreign');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->dropForeign('stocks_supplier_id_foreign');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->dropForeign('stocks_branch_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_category_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_standard_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_source_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_unit_id_foreign');
		});
		Schema::table('product_attribute', function(Blueprint $table) {
			$table->dropForeign('product_attribute_product_id_foreign');
		});
		Schema::table('product_attribute', function(Blueprint $table) {
			$table->dropForeign('product_attribute_attribute_id_foreign');
		});
		Schema::table('cart_items', function(Blueprint $table) {
			$table->dropForeign('cart_items_cart_id_foreign');
		});
		Schema::table('cart_items', function(Blueprint $table) {
			$table->dropForeign('cart_items_product_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_cart_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_address_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_payment_type_id_foreign');
		});
		Schema::table('images', function(Blueprint $table) {
			$table->dropForeign('images_product_id_foreign');
		});
		Schema::table('images', function(Blueprint $table) {
			$table->dropForeign('images_attachment_id_foreign');
		});
		Schema::table('login_attempts', function(Blueprint $table) {
			$table->dropForeign('login_attempts_user_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_permission_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_role_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_role_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_user_id_foreign');
		});
		Schema::table('rewiews', function(Blueprint $table) {
			$table->dropForeign('rewiews_product_id_foreign');
		});
		Schema::table('rewiews', function(Blueprint $table) {
			$table->dropForeign('rewiews_user_id_foreign');
		});
		Schema::table('user_adress', function(Blueprint $table) {
			$table->dropForeign('user_adress_user_id_foreign');
		});
		Schema::table('user_reward_point', function(Blueprint $table) {
			$table->dropForeign('user_reward_point_order_id_foreign');
		});
		Schema::table('user_reward_point', function(Blueprint $table) {
			$table->dropForeign('user_reward_point_user_id_foreign');
		});
		Schema::table('user_detail', function(Blueprint $table) {
			$table->dropForeign('user_detail_user_id_foreign');
		});
		Schema::table('user_detail', function(Blueprint $table) {
			$table->dropForeign('user_detail_title_id_foreign');
		});
		Schema::table('user_payment', function(Blueprint $table) {
			$table->dropForeign('user_payment_user_id_foreign');
		});
		Schema::table('user_payment', function(Blueprint $table) {
			$table->dropForeign('user_payment_payment_type_id_foreign');
		});
		Schema::table('user_payment', function(Blueprint $table) {
			$table->dropForeign('user_payment_payment_id_foreign');
		});
	}
}