<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Attachment extends Eloquent {

	protected $table = 'attachments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('size', 'mime', 'path');
	protected $visible = array('size', 'mime', 'path');

	public function images()
	{
		return $this->hasMany('Image', 'attachment_id');
	}

}