<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CartItems extends Eloquent {

	protected $table = 'cart_items';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('qty', 'price');
	protected $visible = array('qty', 'price');

	public function products()
	{
		return $this->belongsTo('Product', 'product_id');
	}

	public function carts()
	{
		return $this->belongsTo('Cart', 'cart_id');
	}

}