<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PaymentType extends Eloquent {

	protected $table = 'payment_type';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function userAccount()
	{
		return $this->hasMany('UserPayment', 'account_type_id');
	}

	public function orderd()
	{
		return $this->hasMany('Order', 'payment_type_id');
	}

}