<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_th', 'price', 'status', 'category_id');
	protected $visible = array('name_en', 'name_th', 'price', 'status', 'category_id');

	public function stocks()
	{
		return $this->hasMany('Stock', 'product_id');
	}

	public function categories()
	{
		return $this->belongsTo('Category', 'category_id');
	}

	public function standards()
	{
		return $this->belongsTo('Standard', 'standard_id');
	}

	public function sources()
	{
		return $this->belongsTo('Source', 'source_id');
	}

	public function units()
	{
		return $this->belongsTo('Unit', 'unit_id');
	}

	public function productAttribute()
	{
		return $this->hasMany('ProductAttribute', 'product_id');
	}

	public function images()
	{
		return $this->hasMany('Image', 'product_id');
	}

	public function ratings()
	{
		return $this->hasMany('Review', 'product_id');
	}

	public function CartItems()
	{
		return $this->hasMany('CartItems', 'product_id');
	}

}