<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Standard extends Eloquent {

	protected $table = 'standards';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('code', 'name_en', 'name_th');
	protected $visible = array('code', 'name_en', 'name_th');

	public function products()
	{
		return $this->hasMany('Product', 'standard_id');
	}

}