<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLinksTable extends Migration {

	public function up()
	{
		Schema::create('links', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 28);
			$table->string('fullName', 120);
			$table->text('imgSRC');
			$table->string('url', 258);
			$table->integer('priority')->default('0');
			$table->smallInteger('id_category');
			$table->smallInteger('id_status')->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('links');
	}
}