<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Link extends Eloquent {

	protected $table = 'links';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function categories()
	{
		return $this->hasOne('Category', 'id_category');
	}

	public function status()
	{
		return $this->hasOne('Status', 'id_status');
	}

}