<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    public function roles()
    {
        return $this->belongsToMany('App\Role');
    }

    public function loginAttempts()
    {
        return $this->hasMany('App\LoginAttempt');
    }

    public function profile()
    {
        return $this->hasOne('App\Profiel');
    }

    public function searches()
    {
        return $this->hasMany('App\Search');
    }

}