<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('old_page_views', function(Blueprint $table) {
			$table->foreign('file_id')->references('id')->on('files')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('old_page_views', function(Blueprint $table) {
			$table->foreign('news_id')->references('id')->on('news')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('old_page_views', function(Blueprint $table) {
			$table->dropForeign('old_page_views_file_id_foreign');
		});
		Schema::table('old_page_views', function(Blueprint $table) {
			$table->dropForeign('old_page_views_news_id_foreign');
		});
	}
}