<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ParentCreditCard extends Model 
{

    protected $table = 'bf_parent_credit_cards';
    public $timestamps = false;
    protected $fillable = array('parent_credit_card_name', 'parent_credit_card_code', 'parent_credit_card_type_id', 'parent_credit_card_billing_cycle', 'parent_credit_card_status', 'parent_credit_card_next_billing_date');
    protected $visible = array('parent_credit_card_name', 'parent_credit_card_code', 'parent_credit_card_type_id', 'parent_credit_card_billing_cycle', 'parent_credit_card_status', 'parent_credit_card_next_billing_date');

    public function type()
    {
        return $this->belongsTo('ParentCreditCardType', 'parent_credit_card_type_id');
    }

    public function uploads()
    {
        return $this->hasMany('ParentCreditCardUploads', 'parent_credit_card_id');
    }

}