<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBfCreditCardsTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('bf_credit_cards_transactions', function(Blueprint $table) {
			$table->increments('transaction_id');
			$table->integer('child_credit_card_id')->index();
			$table->datetime('transaction_date')->index();
			$table->string('transaction_bank_id', 128);
			$table->string('transaction_detail', 128);
			$table->float('transaction_amount', 10,2);
			$table->integer('transaction_category_id')->index();
			$table->integer('reconciliation_status')->index();
		});
	}

	public function down()
	{
		Schema::drop('bf_credit_cards_transactions');
	}
}