<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAnswersTable extends Migration {

	public function up()
	{
		Schema::create('answers', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->integer('question_id')->unsigned();
			$table->string('answer_body');
			$table->boolean('iscorrect')->nullable();
			$table->boolean('published');
			$table->string('explanation');
		});
	}

	public function down()
	{
		Schema::drop('answers');
	}
}