<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('question', function(Blueprint $table) {
			$table->foreign('quiz_id')->references('id')->on('question')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('question', function(Blueprint $table) {
			$table->foreign('topic_id')->references('id')->on('question')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('question', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('question')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quiz', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('quiz')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('topics', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('topics')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('question')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->foreign('topic_id')->references('id')->on('answers')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('digital_coach', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('digital_coach')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('questionanswers', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('question')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('questionanswers', function(Blueprint $table) {
			$table->foreign('answer_id')->references('id')->on('answers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('usercourses', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('usercourses', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('question', function(Blueprint $table) {
			$table->dropForeign('question_quiz_id_foreign');
		});
		Schema::table('question', function(Blueprint $table) {
			$table->dropForeign('question_topic_id_foreign');
		});
		Schema::table('question', function(Blueprint $table) {
			$table->dropForeign('question_lesson_id_foreign');
		});
		Schema::table('quiz', function(Blueprint $table) {
			$table->dropForeign('quiz_course_id_foreign');
		});
		Schema::table('topics', function(Blueprint $table) {
			$table->dropForeign('topics_course_id_foreign');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_question_id_foreign');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_user_id_foreign');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->dropForeign('lessons_topic_id_foreign');
		});
		Schema::table('digital_coach', function(Blueprint $table) {
			$table->dropForeign('digital_coach_user_id_foreign');
		});
		Schema::table('questionanswers', function(Blueprint $table) {
			$table->dropForeign('questionanswers_question_id_foreign');
		});
		Schema::table('questionanswers', function(Blueprint $table) {
			$table->dropForeign('questionanswers_answer_id_foreign');
		});
		Schema::table('usercourses', function(Blueprint $table) {
			$table->dropForeign('usercourses_user_id_foreign');
		});
		Schema::table('usercourses', function(Blueprint $table) {
			$table->dropForeign('usercourses_course_id_foreign');
		});
	}
}