<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLessonsTable extends Migration {

	public function up()
	{
		Schema::create('lessons', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('topic_id')->unsigned()->index();
			$table->string('lesson_code')->index();
			$table->string('lesson_title');
			$table->string('lesson_obj');
			$table->string('lesson_ws');
			$table->string('lesson_body');
			$table->integer('lesson_grade');
			$table->boolean('lesson_completed');
		});
	}

	public function down()
	{
		Schema::drop('lessons');
	}
}