<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionTable extends Migration {

	public function up()
	{
		Schema::create('question', function(Blueprint $table) {
			$table->increments('id', true)->primary();
			$table->integer('quiz_id')->unsigned();
			$table->integer('topic_id')->unsigned();
			$table->integer('lesson_id');
			$table->string('question_title')->nullable();
			$table->string('question_body');
			$table->string('imagepath')->nullable();
			$table->boolean('published')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('question');
	}
}