<?php

namespace Models/Product;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function brand()
	{
		return $this->belongsTo('Brand', 'brand');
	}

	public function category()
	{
		return $this->belongsTo('Category', 'category_id');
	}

}