<?php

namespace App/Models;

class PromotedUser extends Eloquent {

	protected $table = 'promotedUsers';
	public $timestamps = true;
	protected $fillable = array('user_id', 'about', 'cover_image', 'link', 'is_active', 'start_date', 'end_date');

	public function user()
	{
		return $this->belongsTo('App/Models\User');
	}

	public function payments()
	{
		return $this->hasMany('App/Models\Payment');
	}

	public function pakages()
	{
		return $this->hasMany('App/Models\Product');
	}

}