<?php

namespace City;

class City extends Eloquent {

	protected $table = 'cities';
	public $timestamps = true;
	protected $fillable = array('state_id', 'is_available');

	public function branches()
	{
		return $this->hasMany('Branch');
	}

	public function orders()
	{
		return $this->hasMany('Order');
	}

	public function warehouses()
	{
		return $this->hasMany('Warehouse');
	}

	public function data()
	{
		return $this->hasMany('CityData');
	}

	public function shipments()
	{
		return $this->hasMany('Shipment');
	}

}