<?php

namespace Country;

use Illuminate\Database\Eloquent\Model;

class Country extends Model 
{

    protected $table = 'countries';
    public $timestamps = true;
    protected $fillable = array('country_code', 'flag', 'is_available');

    public function states()
    {
        return $this->hasMany('State');
    }

    public function orders()
    {
        return $this->hasMany('Order');
    }

    public function data()
    {
        return $this->hasMany('CountryData');
    }

}