<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('curreny_id')->unsigned();
			$table->string('warehouse', 191);
			$table->integer('customer_name')->unsigned();
			$table->integer('city_id')->unsigned();
			$table->string('delivery_type', 191);
			$table->string('shipment_number', 191);
			$table->date('order_date');
			$table->float('total_amount');
			$table->enum('payment_method', array('paid', 'tap', 'tapy', 'tamara'));
			$table->integer('status_id')->unsigned();
			$table->string('address', 191);
			$table->string('order_number', 191);
			$table->string('brand_name', 191);
			$table->integer('country_id')->unsigned();
			$table->text('order_comment');
			$table->string('lat', 191);
			$table->string('lang', 191);
			$table->string('product_name', 191);
			$table->string('sku', 191);
			$table->string('item', 191);
			$table->string('quentity', 191);
			$table->float('price');
			$table->float('tax');
			$table->float('total');
			$table->float('grand_total');
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}