<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvitedBiddersTable extends Migration {

	public function up()
	{
		Schema::create('invited_bidders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('bid_id')->unsigned()->index();
			$table->integer('vendor_id')->unsigned()->index();
			$table->string('first_name', 100)->nullable();
			$table->string('last_name', 100)->nullable();
			$table->string('email', 100)->nullable();
			$table->string('company_name', 100)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('invited_bidders');
	}
}