<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBidScheduleTable extends Migration {

	public function up()
	{
		Schema::create('bid_schedule', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('bid_id')->unsigned();
			$table->datetime('open_date');
			$table->datetime('close_date');
			$table->integer('schedule_id')->unsigned()->nullable();
			$table->string('custom_title', 100)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('bid_schedule');
	}
}