<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBidResponsesTable extends Migration {

	public function up()
	{
		Schema::create('bid_responses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('vendor_id')->unsigned()->nullable()->index();
			$table->integer('bid_id')->unsigned()->nullable()->index();
			$table->enum('intend_to_bid', array('yes', 'no'));
			$table->string('conpany_name', 100);
			$table->string('contact_name', 100);
			$table->string('contact_title', 100);
			$table->string('contact_address', 100);
			$table->string('contact_sity_state_zip', 100);
			$table->string('contact_phone', 100);
			$table->string('contact_fax', 100);
			$table->string('contact_email', 100);
			$table->string('typed_name', 100);
			$table->string('phone', 100);
		});
	}

	public function down()
	{
		Schema::drop('bid_responses');
	}
}