<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('officers', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('officers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('officers', function(Blueprint $table) {
			$table->foreign('role_id')->references('role_id')->on('officers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('vendors', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('vendors')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('vendors', function(Blueprint $table) {
			$table->foreign('role_id')->references('role_id')->on('vendors')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_dashboard', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('officers', function(Blueprint $table) {
			$table->dropForeign('officers_user_id_foreign');
		});
		Schema::table('officers', function(Blueprint $table) {
			$table->dropForeign('officers_role_id_foreign');
		});
		Schema::table('vendors', function(Blueprint $table) {
			$table->dropForeign('vendors_user_id_foreign');
		});
		Schema::table('vendors', function(Blueprint $table) {
			$table->dropForeign('vendors_role_id_foreign');
		});
		Schema::table('user_dashboard', function(Blueprint $table) {
			$table->dropForeign('user_dashboard_user_id_foreign');
		});
	}
}