<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateApproversTable extends Migration {

	public function up()
	{
		Schema::create('approvers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('bid_id')->unsigned()->index();
			$table->integer('officer_id')->unsigned()->nullable()->index();
			$table->datetime('due_date');
			$table->string('first_name', 255)->nullable();
			$table->string('last_name', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('title', 255)->nullable();
			$table->tinyInteger('approved')->unsigned();
			$table->integer('order')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('approvers');
	}
}