<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesTable extends Migration {

	public function up()
	{
		Schema::create('services', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('vendor_id')->unsigned()->index();
			$table->integer('category_id')->unsigned()->index();
			$table->string('name', 255);
			$table->string('description', 2000);
			$table->enum('type', array(''product'', ''service''))->index();
		});
	}

	public function down()
	{
		Schema::drop('services');
	}
}