<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserDashboardTable extends Migration {

	public function up()
	{
		Schema::create('user_dashboard', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->integer('dashboard_section_id');
			$table->enum('status', array('show', 'hide'));
			$table->enum('column', array('left', 'right'));
			$table->integer('order_position');
		});
	}

	public function down()
	{
		Schema::drop('user_dashboard');
	}
}