<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLoanInformationTable extends Migration {

	public function up()
	{
		Schema::create('LoanInformation', function(Blueprint $table) {
			$table->increments('id');
			$table->string('loan_type', 255);
			$table->integer('loan_amount_requested');
			$table->integer('minimum_term_length');
			$table->integer('maximum_term_length');
			$table->integer('minimum_amortization_length');
			$table->integer('preferred_amortization_length');
			$table->string('interest_only_option');
			$table->string('moratorium_period_required', 255);
			$table->string('funding_date', 255);
			$table->string('key_features', 255);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('LoanInformation');
	}
}